<?php
if(!isset($_POST['submit'])){
    //search for pages here or easier option is to display all the pages here
   displayAllPages();
    page();
}else{
    if($_POST['submit'] == "displayPage"){
        $id = filter_var($_POST['id'], FILTER_SANITIZE_URL);
        page($id);
    }elseif($_POST['submit'] == 'editPage'){
        //page has been updated and ready to upload to the DB
        //echo var_dump($_POST);
        $id = filter_var($_POST['id'],FILTER_SANITIZE_ADD_SLASHES);//select a filter
        $newTitle = filter_var($_POST['title'],FILTER_SANITIZE_FULL_SPECIAL_CHARS); //select a filter
        $newH1 = filter_var($_POST['h1'],FILTER_SANITIZE_FULL_SPECIAL_CHARS); //select a filter
        $newContent = filter_var($_POST['content'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newNavBarDisplay = filter_var($_POST['navBarDisplay'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newNavBarOrder = filter_var($_POST['navBarOrder'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newNavBarText = filter_var($_POST['navBarText'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newActive = filter_var($_POST['active'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newSearchable = filter_var($_POST['searchable'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newIncludes = filter_var($_POST['includes'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newDtg = time();

        $newLink = filter_var($_POST['link'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $originalPageLink = filter_var($_POST['originalPageLink'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
        $newPriv = filter_var($_POST['priv'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);

        //Check to see if link is unique
        $newLink = linkChecka($newLink, $id);//ensures that the link is unique

        //look for the site styles in the code
        //CONVERT [h1] to <h1>
        $newContent = siteStyles("in",$newContent);
        //do some error checking
    if($newTitle == ""){
        $error[] = "You need to specify a page title";
    }
    if($newH1 == ""){
        $error[] = "You need to specify a page heading";
    }
    if($newNavBarText == "") {
        $error[] = "You need to specify text for your nav bar";
    }
    if(isset($error)){
        //if this is set,then there must be an error
        //iterate through the errors here
        $errorMessages = "";
        foreach($error as $val){
                $errorMessages .= $val . '<br>';
        }
            $_SESSION['msg'] = $errorMessages;
            $_SESSION['msg_type'] = 'error';
            msg();
            page("error");
            //die(); // we will remove this next week
        }else{

            //upload the new page details onto the DB if there isn't an error
            //var_dump($_POST);
            $query = "UPDATE content SET title = ?, h1 = ?, content = ?, link = ?, navBarDisplay = ?, navBarOrder = ?, navBarText = ?,
            includes = ?, dtg = ?, searchable = ?, active = ?, priv = ? WHERE id = ?";
            connectDB();
            $stmt = mysqli_prepare($_SESSION['db'], $query);
            mysqli_stmt_bind_param($stmt, 'sssssississii', $newTitle, $newH1, $newContent, $newLink, $newNavBarDisplay, $newNavBarOrder,$newNavBarText,$newIncludes, $newDtg, $newSearchable, $newActive, $newPriv, $id);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            closeDB();
            //redirect the user to the new updated page
        ?> 
        <script>
            window.location.replace("index.php?link=<?=$newLink?>");
        </script>
        <?
        }
        }elseif($_POST['submit']=="newPage"){ //If new page
            //var_dump($_POST);
            //$id = filter_var($_POST['id'],FILTER_SANITIZE_ADD_SLASHES);//select a filter
            $newTitle = filter_var($_POST['title'],FILTER_SANITIZE_FULL_SPECIAL_CHARS); //select a filter
            $newH1 = filter_var($_POST['h1'],FILTER_SANITIZE_FULL_SPECIAL_CHARS); //select a filter
            $newContent = filter_var($_POST['content'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newNavBarDisplay = filter_var($_POST['navBarDisplay'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newNavBarOrder = filter_var($_POST['navBarOrder'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newNavBarText = filter_var($_POST['navBarText'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newActive = filter_var($_POST['active'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newSearchable = filter_var($_POST['searchable'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newIncludes = filter_var($_POST['includes'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newDtg = time();
            $newLink = filter_var($_POST['link'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
            $newPriv = filter_var($_POST['priv'],FILTER_SANITIZE_FULL_SPECIAL_CHARS);
    
            //Check to see if link is unique
            $newLink = linkChecka($newLink, '');//ensures that the link is unique
    
            //look for the site styles in the code
            //CONVERT [h1] to <h1>
            $newContent = siteStyles("in",$newContent);
            if($newTitle == ""){
                $error[] = "You need to specify a page title";
            }
            if($newH1 == ""){
                $error[] = "You need to specify a page heading";
            }
            if($newNavBarText == "") {
                $error[] = "You need to specify text for your nav bar";
            }
            if(isset($error)){
                //if this is set,then there must be an error
                //iterate through the errors here
                $errorMessages = "";
                foreach($error as $val){
                        $errorMessages .= $val . '<br>';
                }
                    $_SESSION['msg'] = $errorMessages;
                    $_SESSION['msg_type'] = 'error';
                    msg();
                    page("error");
                    //die(); // we will remove this next week
                }else{
        
                    //upload the new page details onto the DB if there isn't an error
                    //var_dump($_POST);
                    //$query = "UPDATE content SET title = ?, content = ?, link = ?, navBarDisplay = ?, navBarOrder = ?, navBarText = ?,
                    //includes = ?, dtg = ?, searchable = ?, active = ?, priv = ? WHERE id = ?";
                    $query = "INSERT INTO content (title,h1,content,link,navBarDisplay,navBarOrder,navBarText,includes,dtg,searchable,active,priv,owner) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    connectDB();
                    $stmt = mysqli_prepare($_SESSION['db'], $query);
                    mysqli_stmt_bind_param($stmt, 'sssssississii', $newTitle, $newH1, $newContent, $newLink,
                    $newNavBarDisplay,$newNavBarOrder,$newNavBarText,$newIncludes, $newDtg, 
                    $newSearchable, $newActive, $newPriv, $_SESSION['userId']);
                    mysqli_stmt_execute($stmt);
                    $result = mysqli_stmt_get_result($stmt);
                    closeDB();
                    //redirect the user to the new updated page
                ?> 
                <script>
                    window.location.replace("index.php?link=<?=$newLink?>");
                </script>
                <?
                }

        }
        }
//add a new page

//edit an existing page
    //edit directly from the edit this page button
    //search from existing pages to edit
        //display search results
        //display selected page to edit

//delete a page
//page("Home");//Edit an existing page
//page("secret"); //Create a new page
function page($id = "newPage"){
    if($id != "newPage" && $id != 'error'){
        //get page details from the database here
        $id = trim(filter_var($id, FILTER_SANITIZE_FULL_SPECIAL_CHARS));
        $query = "SELECT * FROM content WHERE id = ?";
        connectDB();
        $stmt = mysqli_prepare($_SESSION['db'], $query);
        mysqli_stmt_bind_param($stmt, 'i', $id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        closeDB();
        $row = mysqli_fetch_assoc($result);
    }
        ?>
        
            <form action="" method="post" id="editForm">
            <fieldset><legend><? if($id != "newPage" && $id != 'error'){
        echo "Edit this page.";
    }else{
        echo"Create a new page.";
    }
        ?>
        </legend>
            <div><label for="title">Title: </label> 
            <input type="text" name="title" value="<?
            if(isset($row['title'])){ echo $row['title'];
            }else{
                //sticky forms
                if(isset($_POST['title'])){ echo $_POST['title'];
                    }
            }
            ?>" placeholder="Page title" id="title"></div>

<div><label for="h1">Main heading: </label> 
            <input type="text" name="h1" value="<?
            if(isset($row['h1'])){ 
                echo $row['h1'];
            }else{
                //sticky forms
                if(isset($_POST['h1'])){ 
                    echo $_POST['h1'];
                    }
            }
            ?>" placeholder="Page heading" id="h1"></div>

            <div><label for="content">Content: </label> 
            <textarea name="content" id="content"><? 
            if(isset($row['content'])){ 
                   echo siteStyles("out",$row['content']);
            }else{
                if(isset($_POST['content'])){
                    //sticky forms
                    echo $_POST['content'];
                    }else{
                        //must be a new page
                        echo "Enter the page content here.";                   
                    };    
            }    
            ?>
            </textarea></div>
            <div><label for="link">Page link: </label> 
            <input type="text" name="link" id="link" value="<?
            if(isset($row['link'])){ 
                echo $row['link'];
                }else{
                    //sticky forms
                    if(isset($_POST['link'])){ 
                        echo $_POST['link'];
                }
            }
                ?>" placeholder="Page link"></div>

<? if($id != "newPage" && $id != 'error'){
        ?>
             <input type="hidden" name="originalPageLink" value="<? if(isset($row['link'])){ echo $row['link']; }else{ echo $_POST['originalPageLink'];}?>">     

            <?
            }
            ?>






          
        <div><label for="navBarText">Nav bar text: </label> 
            <input type="text" name="navBarText" id="navBarText" value="<?
            if(isset($row['navBarText'])){ 
                echo $row['navBarText'];
                }else{
                    //sticky forms
                    if(isset($_POST['navBarText'])){ 
                        echo $_POST['navBarText'];
                }
            }
                ?>" placeholder="Nav bar clickable text label"></div>
                


        <div><label for="NavBarOrder">Nav bar order: </label> 
            <input type="text" name="navBarOrder" id="navBarOrder" value="<?
            if(isset($row['navBarOrder'])){ 
                echo $row['navBarOrder'];
                }else{
                    //sticky forms
                    if(isset($_POST['navBarOrder'])){ 
                        echo $_POST['navBarOrder'];
                }
            }
                ?>" placeholder="Nav bar order"></div>

<div><label for="navBarDisplay">Nav bar display: </label> 
<select name="navBarDisplay" id="navBarDisplay">
    <?
    if(isset($row['navBarDisplay'])){
        if($row['navBarDisplay'] == 'y'){
            $display = 'y';
        }else{
            $display = 'n';
        }
    }else{
            if($_POST['navBarDisplay']=='y'){
                $display = 'y';
            }else{
                $display = 'n';
            }
        }
        ?>
<option value="y" <? if($display =='y'){ echo "selected"; }?>>Yes</option>
<option value="n" <? if($display =='n'){ echo "selected"; }?>>No</option>
        </select>
        </div>
        <div><label for="includes">Includes: </label> 
            <input type="text" name="includes" id="includes" value="<?
            if(isset($row['includes'])){ 
                echo $row['includes'];
                }else{
                    //sticky forms
                    if(isset($_POST['includes'])){ 
                        echo $_POST['includes'];
                }
            }
                ?>" placeholder="Includes file"></div>
        <div><label for="searchable">Searchable: </label> 
        <select name="searchable" id="searchable">

        <?
    if(isset($row['searchable'])){
        if($row['searchable'] == 'y'){
            $display = 'y';
        }else{
            $display = 'n';
        }
    }else{
        if($_POST['searchable']=='y'){
            $display = 'y';
        }else{
            $display = 'n';
        }
        }
        ?>
        <option value="y" <? if($display == 'y'){ echo "selected"; }?>>Yes</option>
        <option value="n" <? if($display == 'n'){ echo "selected"; }?>>No</option>
        </select>
        </div>
        
        <div><label for="active">Active: </label> 
        <select name="active" id="active">
        <?
    if(isset($row['active'])){
        if($row['active'] == 'y'){
            $display = 'y';
        }else{
            $display = 'n';
        }
    }else{
        if($_POST['active']=='y'){
            $display = 'y';
        }else{
            $display = 'n';
        }
        }
        ?>
        <option value="y" <? if($display == 'y'){ echo "selected"; }?>>Yes</option>
        <option value="n" <? if($display == 'n'){ echo "selected"; }?>>No</option>
        </select>
        </div>








        <div><label for="priv">Priv: </label> 
        <select name="priv" id="priv">
        <?
    if(isset($row['priv'])){
        $privValue = $row['priv'];
        }else{
            $privValue = 0;
        }
        ?>
    
        <option value="0" <? if($privValue==0){ echo "selected"; }?>>Public (0)</option>
        <option value="1" <? if($privValue==1){ echo "selected"; }?>>User (1)</option>
        <option value="2" <? if($privValue==2){ echo "selected"; }?>>Admin (2)</option>
        <option value="3" <? if($privValue==3){ echo "selected"; }?>>Super Admin (3)</option>
        
        </select>
        </div>

       <? if($id != "newPage" && $id != 'error'){
        ?>
        <input type="hidden" name="id" value="<? if(isset($row['id'])){ echo $row['id'];}else{ echo $_POST['id'];}?>">
            <button type="submit" name="submit" value="editPage">Update the page</button>
            <?
            }else{
                ?>
              <button type="submit" name="submit" value="newPage">Create new page</button>  
                <?
            }?>
            </fieldset>
        </form>
    
<?
}

function linkChecka($l,$id = null){
    //checks DB if link exists (excluding it's own page)
    $l = trim(filter_var($l, FILTER_SANITIZE_FULL_SPECIAL_CHARS));
    if($l == ""){ $l = sha1(time());}
    connectDB();
    if($id!=null){
        $query = "SELECT * FROM content WHERE link = ? AND id != ?";
        $stmt = mysqli_prepare($_SESSION['db'], $query);
        mysqli_stmt_bind_param($stmt, 'si', $l, $id);
    }else{
        $query = "SELECT * FROM content WHERE link = ?";
        $stmt = mysqli_prepare($_SESSION['db'], $query);
        mysqli_stmt_bind_param($stmt, 's', $l);
    }
    
    
    
    
   
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    closeDB();
    $row = mysqli_fetch_assoc($result);
    if(mysqli_num_rows($result)>0){
        //link exists on the DB - need to now make unique
        $uniqueLink = linkChecka($tempLink = $l . sha1(time()),$id);
    }else{
        //new link is unique
        //continue without change
        $uniqueLink = $l;

    }
    //return unique link
    return $uniqueLink;
    
}
function displayAllPages(){
    connectDB();
    $query = "SELECT * FROM content";
    $stmt = mysqli_prepare($_SESSION['db'], $query);
    //mysqli_stmt_bind_param($stmt);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    closeDB();
    $_SESSION['token'] = bin2hex(openssl_random_pseudo_bytes(16));
    ?>

  <div class='search'> <input type="text" id="search" data-token="<?=$_SESSION['token']?>"><i class="bi bi-search"></i></div>
  <div class="search_result"></div>
<form method="post" action="">
    <select name="id">
    <option selected>Select a page</option>
    <?
    
    $row = mysqli_fetch_assoc($result);
    while($row = mysqli_fetch_assoc($result)){
        ?>
        <option value="<?=$row['id']?>"><?=$row['title']?></option>
        <?

    }
    ?>
    </select>
    <button type="submit" name="submit" value="displayPage">Edit selected page</button>
    </form>
    <script src="js/main.js"></script>
    <?
}
?>