<?php session_start();
require_once("includes.php");

if(ISSET($_GET['link'])){
$pageLink = filter_var(trim($_GET['link']), FILTER_SANITIZE_FULL_SPECIAL_CHARS);

}else{
   $pageLink = 'Home'; 
}
$query = "SELECT * FROM content WHERE link = ?";
connectDB();
$stmt = mysqli_prepare($_SESSION['db'],$query);
mysqli_stmt_bind_param($stmt,'s',$pageLink);
// s is for string
// d is for double
// i is for integer
// b is for blob

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

closeDB();
if(mysqli_num_rows($result) > 0){
    $row = mysqli_fetch_assoc($result);
}else{
    header("Location: index.php?link=404");

}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/styles.css">
    <title><?=$row['title']?></title>
    <link rel="stylesheet" href="css/main.css">
</head>
<body>
<?
nav();
?>
    <h1><?=$row['h1']?></h1>
    <p><?=$row['content']?></p>
    <?php
    

?>
</body>
</html>